//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "I2CMasterChannelUseCase.h"
@implementation I2CMasterChannelUseCase: NSObject

#pragma mark - sharedInstance
+ (I2CMasterChannelUseCase *) sharedInstance;
{
    static I2CMasterChannelUseCase *sharedInstance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{ sharedInstance = [[I2CMasterChannelUseCase alloc] init]; });
    return sharedInstance;
}

#pragma mark - configSensorI2CMaster
- (void) configSensorI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Set Stand By Mode
    ISO15693Command *setStandByModeI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_setStandByModeI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: setStandByModeI2CMasterCommand onSuccess:^(NSData *aData) {
    } onFailure:^(NSError *error) {
        NSLog(@"configSensorI2CMaster error :\n%@", error.localizedDescription);
        return;
    }];
    
    // Set Hybrid Mode
    ISO15693Command *setHybridModeI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_setHybridModeI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: setHybridModeI2CMasterCommand onSuccess:^(NSData *aData) {
    } onFailure:^(NSError *error) {
        NSLog(@"configSensorI2CMaster error :\n%@", error.localizedDescription);
        return;
    }];
    
    // Set Control Reg 2
    ISO15693Command *setControlReg2I2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_setControlReg2I2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: setControlReg2I2CMasterCommand onSuccess:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        NSLog(@"configSensorI2CMaster error :\n%@", error.localizedDescription);
        return;
    }];
    
    // Set Active Mode
    ISO15693Command *setActiveModeI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_setActiveModeI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: setActiveModeI2CMasterCommand onSuccess:^(NSData *aData) {
        success(aData);
        
    } onFailure:^(NSError *error) {
        NSLog(@"configSensorI2CMaster error :\n%@", error.localizedDescription);
        return;
    }];
}

#pragma mark - getTempI2CMaster
- (void) getTempI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Get Temperature Data
    ISO15693Command *getTempI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_GetTempI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: getTempI2CMasterCommand onSuccess:^(NSData *aData) {
        success(aData);
    } onFailure:^(NSError *error) {
        NSLog(@"getTempI2CMaster error :\n%@", error.localizedDescription);
    }];
    
    // Read data
    [[I2CMasterChannelUseCase sharedInstance] readData:^(NSData *aData) {
        success(aData);
    } onFailure:^(NSError *error) {
        NSLog(@"getTempI2CMaster error :\n%@", error.localizedDescription);
        
    }];
}

#pragma mark - getAccelXI2CMaster
- (void) getAccelXI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Get Accelerometer Data X-axis
    ISO15693Command *getXaccMSBI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_GetXaccMSBI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: getXaccMSBI2CMasterCommand onSuccess:^(NSData *aData){
        
    } onFailure:^(NSError *error) {
        NSLog(@"getAccelXI2CMaster error :\n%@", error.localizedDescription);
    }];
    
    // Read data
    [[I2CMasterChannelUseCase sharedInstance] readData:^(NSData *aData) {
        success(aData);
        
    } onFailure:^(NSError *error) {
        NSLog(@"getAccelXI2CMaster error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - getAccelYI2CMaster
- (void) getAccelYI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Get Accelerometer Data Y-axis
    ISO15693Command *getYaccMSBI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_GetYaccMSBI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: getYaccMSBI2CMasterCommand onSuccess:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        NSLog(@"getAccelYI2CMaster error :\n%@", error.localizedDescription);
    }];
    
    // Read Data
    [[I2CMasterChannelUseCase sharedInstance] readData:^(NSData *aData) {
        success(aData);
        
    } onFailure:^(NSError *error) {
        NSLog(@"getAccelYI2CMaster error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - getAccelZI2CMaster
- (void) getAccelZI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Get Accelerometer Data Z-axis
    ISO15693Command *getZaccMSBI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_GetZaccMSBI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: getZaccMSBI2CMasterCommand onSuccess:^(NSData *aData) {
    } onFailure:^(NSError *error) {
        NSLog(@"getAccelZI2CMaster error :\n%@", error.localizedDescription);
    }];
    
    // Read Data
    [[I2CMasterChannelUseCase sharedInstance] readData:^(NSData *aData) {
        success(aData);
        
    } onFailure:^(NSError *error) {
        NSLog(@"getAccelZI2CMaster error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - getMagnetXI2CMaster
- (void) getMagnetXI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Read Magnetometer Data X-axis
    ISO15693Command *getXmagMSBI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_GetXmagMSBI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: getXmagMSBI2CMasterCommand onSuccess:^(NSData *aData) {
    } onFailure:^(NSError *error) {
        NSLog(@"getMagnetXI2CMaster error :\n%@", error.localizedDescription);
    }];
    
    // Read Data
    [[I2CMasterChannelUseCase sharedInstance] readData:^(NSData *aData) {
        success(aData);
    } onFailure:^(NSError *error) {
        NSLog(@"getMagnetXI2CMaster error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - getMagnetYI2CMaster
- (void) getMagnetYI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Read Magnetometer Data Y-axis
    ISO15693Command *getYmagMSBI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_GetYmagMSBI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: getYmagMSBI2CMasterCommand onSuccess:^(NSData *aData) {
    } onFailure:^(NSError *error) {
        NSLog(@"getMagnetYI2CMaster error :\n%@", error.localizedDescription);
    }];
    
    // Read Data
    [[I2CMasterChannelUseCase sharedInstance] readData:^(NSData *aData) {
        success(aData);
        
    } onFailure:^(NSError *error) {
        NSLog(@"getMagnetYI2CMaster error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - getMagnetZI2CMaster
- (void) getMagnetZI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Read Magnetometer Data Z-axis
    ISO15693Command *getZmagMSBI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_GetZmagMSBI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: getZmagMSBI2CMasterCommand onSuccess:^(NSData *aData) {
    } onFailure:^(NSError *error) {
        NSLog(@"getMagnetZI2CMaster error :\n%@", error.localizedDescription);
    }];
    
    // Read Data
    [[I2CMasterChannelUseCase sharedInstance] readData:^(NSData *aData) {
        success(aData);
        
    } onFailure:^(NSError *error) {
        NSLog(@"getMagnetZI2CMaster error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - readData
- (void) readData:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Read I2C Master
    ISO15693Command *readI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_readI2CMasterCommand];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readI2CMasterCommand onSuccess:^(NSData *aData) {
    } onFailure:^(NSError *error) {
    }];
    
    // Read SRAM
    ISO15693Command *readSRAMI2CMaster = [[ISO15693Command alloc] initWithData:cmd_readSRAMI2CMaster];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readSRAMI2CMaster onSuccess:^(NSData *aData) {
        success(aData);
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_success];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {}];
        
    } onFailure:^(NSError *error) {
        NSLog(@"readData error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - sendCustomCommand
- (void) sendCustomCommand: (NSString *) cmd cmd: (void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    // Send Custom Command
    ISO15693Command *customCommand = [[ISO15693Command alloc] initWithData:cmd];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: customCommand onSuccess:^(NSData *aData) {
        
    } onFailure:^(NSError *error) {
        NSLog(@"sendCustomCommand error :\n%@", error.localizedDescription);
    }];
    
    // Read I2C Master
    ISO15693Command *readI2CMasterCommand = [[ISO15693Command alloc] initWithData:cmd_readI2CMasterCommand];

    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readI2CMasterCommand onSuccess:^(NSData *aData) {
    } onFailure:^(NSError *error) {
        NSLog(@"sendCustomCommand error :\n%@", error.localizedDescription);
    }];
    
    // Get I2C Master Configuration Status
    ISO15693Command *i2cMasterConfigStatus = [[ISO15693Command alloc] initWithData:cmd_i2cMasterConfigStatus];
    
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: i2cMasterConfigStatus onSuccess:^(NSData *aData) {
    } onFailure:^(NSError *error) {
        NSLog(@"sendCustomCommand error :\n%@", error.localizedDescription);
    }];
    
    // Read SRAM
    ISO15693Command *readSRAMI2CMaster = [[ISO15693Command alloc] initWithData:cmd_readSRAMI2CMaster];
    
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readSRAMI2CMaster onSuccess:^(NSData *aData) {
        success(aData);
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_success];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {
            NSLog(@"sendCustomCommand error :\n%@", error.localizedDescription);
        }];
        
    } onFailure:^(NSError *error) {
        NSLog(@"sendCustomCommand error :\n%@", error.localizedDescription);
    }];
}


@end
